#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <vector>

#include "searcher.h"
#include "log.h"
#include "utils.h"



using namespace std;

void cSearcher::setininame(string name)
{
    opt->inifilename = name;
    cout<<"\n reading supplied ini filename : "<<name;
    if(logger.islog()) logger.file<<"new ini file <"<<name<<">";
}

void cSearcher::readini(string ininame)
{
    string line;
    vector<string> inilines;
    ifstream file (ininame.c_str());

    if(!file)
    {
        cout<<"\n ini file not found \n";
        if(logger.islog()) logger.file<<"\n ini file not found \n";
        return;
    }

#ifdef DEBUG
    cout<<"\n reading ini file "<<ininame<<endl;
#endif


    if (file.is_open())
    {
      while (! file.eof() )
      {
       getline (file,line);
       inilines.push_back(line);
      }
      if(inilines.size())
      {
      processini(inilines);
#ifdef DEBUG
       showinivals();
#endif
      }
    }

    file.close();

    return;
}

void cSearcher::processini(vector<string> options)
{
    uint linenum;
    string temp;
	uint temp2 = 0;
    int pos;
    for(linenum=0; linenum < options.size(); ++linenum)
    {
        if(findsubstrend("#", options[linenum], pos))  { continue; }
		else if(findsubstrend("tablehash ", options[linenum], pos)) 
		{
			temp2  = strtoint(options[linenum],pos);
			if(temp2 > 1024) temp2 = 1024;
			if(temp2 < 16) temp2 = 16;
			ttable.delete_tables();
			ttable.makenewtable(temp2);
			continue;
		}
		else if(findsubstrend("psrtuctdoubledopen ", options[linenum], pos))  {  scorer.doubledopen  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctdoubledend ", options[linenum], pos))  {  scorer.doubledend  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctisolatedopen ", options[linenum], pos))  {  scorer.isolatedopen  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctisolatedend ", options[linenum], pos))  {  scorer.isolatedend  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctopenfileopen ", options[linenum], pos))  {  scorer.openfileopen  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctopenfileend ", options[linenum], pos))  {  scorer.openfileend  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctpasseropen ", options[linenum], pos))  {  scorer.passeropen  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("psrtuctpasserend ", options[linenum], pos))  {  scorer.passerend  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("rookopenfile ", options[linenum], pos))  {  scorer.rookopenfile  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("rooksemiopenfile ", options[linenum], pos))  {  scorer.rooksemiopenfile  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("rookseventhrank ", options[linenum], pos))  {  scorer.rookseventhrank  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("queenseventhrank ", options[linenum], pos))  {  scorer.queenseventhrank  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobbishopmobmin ", options[linenum], pos))  {  scorer.bishopmobmin  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobbishopmobmax ", options[linenum], pos))  {  scorer.bishopmobmax  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobknightmobmin ", options[linenum], pos))  {  scorer.knightmobmin  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobknightmobmax ", options[linenum], pos))  {  scorer.knightmobmax  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobrookmobmin ", options[linenum], pos))  {  scorer.rookmobmin  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobrookmobmax ", options[linenum], pos))  {  scorer.rookmobmax  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobqueenmobmin ", options[linenum], pos))  {  scorer.queenmobmin  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobqueenmobmax ", options[linenum], pos))  {  scorer.queenmobmax  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("mobpin ", options[linenum], pos))  {  scorer.pin  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("devminordev ", options[linenum], pos))  {  scorer.minordev  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("devmajorsoon ", options[linenum], pos))  {  scorer.majorsoon  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("blotrR ", options[linenum], pos))  {  scorer.trR  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("blotrB ", options[linenum], pos))  {  scorer.trB  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("blotrP ", options[linenum], pos))  {  scorer.trP  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("searchusehash ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") opt->usehash = true;
            else opt->usehash = false;
            continue;
        }
        else if(findsubstrend("searchdonull ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") opt->donull = true;
            else opt->donull = false;
            continue;
        }
        else if(findsubstrend("searchpvs ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") opt->pvs = true;
            else opt->pvs = false;
            continue;
        }
        else if(findsubstrend("searchnullredfact ", options[linenum], pos))  { opt->nullredfact  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("searchaspwindow ", options[linenum], pos))  { opt->aspwindow  = strtoint(options[linenum],pos); continue; }
        else if(findsubstrend("histab ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") mlist.opt->histab = true;
            else mlist.opt->histab = false;
            continue;
        }
        else if(findsubstrend("searchaspiration ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") opt->aspiration = true;
            else opt->aspiration = false;
            continue;
        }
        else if(findsubstrend("ordermvvlva ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") mlist.opt->mvvlva = true;
            else mlist.opt->mvvlva = false;
            continue;
        }
        else if(findsubstrend("orderkiller ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") mlist.opt->killer = true;
            else mlist.opt->killer = false;
            continue;
        }
        else if(findsubstrend("orderhashmove ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") mlist.opt->hashmove = true;
            else mlist.opt->hashmove = false;
            continue;
        }
        else if(findsubstrend("ordermatekiller ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") mlist.opt->matekiller = true;
            else mlist.opt->matekiller = false;
            continue;
        }
        else if(findsubstrend("evoptdevelopment ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->development = true;
            else scorer.opt->development = false;
            continue;
        }
        else if(findsubstrend("evoptblocked ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->blocked = true;
            else scorer.opt->blocked = false;
            continue;
        }
        else if(findsubstrend("evoptknights ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->knights = true;
            else scorer.opt->knights = false;
            continue;
        }
        else if(findsubstrend("evoptbishops ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->bishops = true;
            else scorer.opt->bishops = false;
            continue;
        }
        else if(findsubstrend("evoptrooks ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->rooks = true;
            else scorer.opt->rooks = false;
            continue;
        }
        else if(findsubstrend("evoptqueens ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->queens = true;
            else scorer.opt->queens = false;
            continue;
        }
        else if(findsubstrend("evoptpawns ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->pawns = true;
            else scorer.opt->pawns = false;
            continue;
        }
        else if(findsubstrend("evoptpsqt ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="true") scorer.opt->psqt = true;
            else scorer.opt->psqt = false;
            continue;
        }
        else if(findsubstrend("log ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="on")
            {
                logger.setlog(true);
                logger.init();
            }
            continue;
        }
        else if(findsubstrend("book ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            if(options[linenum]=="on")
            {
                book.setbookuse(true);
            }
            else
            {
                book.setbookuse(false);
            }
            continue;
        }
        else if(findsubstrend("bookname ", options[linenum], pos))
        {
            options[linenum].erase(0,pos);
            book.setbookname(options[linenum]);
            continue;
        }

    }


    scorer.init_mobility();
    mat.init_psqt();
    if(book.usingbook())  book.init_book();
    return;
}


void cSearcher::showinivals()
{
    cout<<"\n ini file values : \n";
	cout<<"\ntablehash   "<<ttable.getelements()<<" MB" ;
    cout<<"\ndoubledopen   "<<scorer.doubledopen ;
    cout<<"\ndoubledend   "<<scorer.doubledend ;
    cout<<"\nisolatedopen   "<<scorer.isolatedopen ;
    cout<<"\nisolatedend   "<<scorer.isolatedend ;
    cout<<"\nopenfileopen   "<<scorer.openfileopen ;
    cout<<"\nopenfileend   "<<scorer.openfileend ;
    cout<<"\npasseropen   "<<scorer.passeropen ;
    cout<<"\npasserend   "<<scorer.passerend ;
    cout<<"\nbishopmobmin "<<scorer.bishopmobmin;
    cout<<"\nbishopmobmax "<<scorer.bishopmobmax;
    cout<<"\nknightmobmin "<<scorer.knightmobmin;
    cout<<"\nknightmobmax "<<scorer.knightmobmax;
    cout<<"\nrookmobmin "<<scorer.rookmobmin;
    cout<<"\nrookmobmax "<<scorer.rookmobmax;
    cout<<"\nqueenmobmin "<<scorer.queenmobmin;
    cout<<"\nqueenmobmax "<<scorer.queenmobmax;
    cout<<"\npin "<<scorer.pin;
    cout<<"\nminordev "<<scorer.minordev;
    cout<<"\nmajorsoon "<<scorer.majorsoon;
    cout<<"\ntrR "<<scorer.trR;
    cout<<"\ntrB "<<scorer.trB;
    cout<<"\ntrP "<<scorer.trP;
    cout<<"\nusehash "<<opt->usehash;
    cout<<"\ndonull "<<opt->donull;
    cout<<"\nnullredfact "<<opt->nullredfact;
    cout<<"\nhistab "<<mlist.opt->histab;
    cout<<"\nmvvlva "<<mlist.opt->mvvlva;
    cout<<"\nkiller "<<mlist.opt->killer;
    cout<<"\nhashmove "<<mlist.opt->hashmove;
    cout<<"\nmatekiller "<<mlist.opt->matekiller;
    cout<<"\nevalpawns "<<scorer.opt->pawns;
    cout<<"\nevaldevelopment "<<scorer.opt->development;
    cout<<"\nevalpsqt "<<scorer.opt->psqt;
    cout<<"\nevalblocked "<<scorer.opt->blocked;
    cout<<"\nevalknights "<<scorer.opt->knights;
    cout<<"\nevalbishops "<<scorer.opt->bishops;
    cout<<"\nevalrooks "<<scorer.opt->rooks;
    cout<<"\nevalqueens "<<scorer.opt->queens;
    cout<<"\nsearchusehash "<<opt->usehash;
    cout<<"\nsearchpvs "<<opt->pvs;
    cout<<"\nsearchdonull "<<opt->donull;
    cout<<"\nsearchnullredfact "<<opt->nullredfact;
    cout<<"\nsearchaspwindow "<<opt->aspwindow;
    cout<<"\nsearchaspiration "<<opt->aspiration;
    cout<<endl;

    if(logger.islog())
    {
    logger.file<<"int values from ";
    logger.file<<" ini file : <"<<opt->inifilename<<">"<<endl;
	logger.file<<"\ntablehash   "<<ttable.getelements()<<" MB" ;
    logger.file<<"\ndoubledopen   "<<scorer.doubledopen ;
    logger.file<<"\ndoubledend   "<<scorer.doubledend ;
    logger.file<<"\nisolatedopen   "<<scorer.isolatedopen ;
    logger.file<<"\nisolatedend   "<<scorer.isolatedend ;
    logger.file<<"\nopenfileopen   "<<scorer.openfileopen ;
    logger.file<<"\nopenfileend   "<<scorer.openfileend ;
    logger.file<<"\npasseropen   "<<scorer.passeropen ;
    logger.file<<"\npasserend   "<<scorer.passerend ;
    logger.file<<"\nbishopmobmin "<<scorer.bishopmobmin;
    logger.file<<"\nbishopmobmax "<<scorer.bishopmobmax;
    logger.file<<"\nknightmobmin "<<scorer.knightmobmin;
    logger.file<<"\nknightmobmax "<<scorer.knightmobmax;
    logger.file<<"\nrookmobmin "<<scorer.rookmobmin;
    logger.file<<"\nrookmobmax "<<scorer.rookmobmax;
    logger.file<<"\nqueenmobmin "<<scorer.queenmobmin;
    logger.file<<"\nqueenmobmax "<<scorer.queenmobmax;
    logger.file<<"\npin "<<scorer.pin;
    logger.file<<"\nminordev "<<scorer.minordev;
    logger.file<<"\nmajorsoon "<<scorer.majorsoon;
    logger.file<<"\ntrR "<<scorer.trR;
    logger.file<<"\ntrB "<<scorer.trB;
    logger.file<<"\ntrP "<<scorer.trP;
    logger.file<<"\nusehash "<<opt->usehash;
    logger.file<<"\ndonull "<<opt->donull;
    logger.file<<"\nnullredfact "<<opt->nullredfact;
    logger.file<<"\nhistab "<<mlist.opt->histab;
    logger.file<<"\nmvvlva "<<mlist.opt->mvvlva;
    logger.file<<"\nkiller "<<mlist.opt->killer;
    logger.file<<"\nhashmove "<<mlist.opt->hashmove;
    logger.file<<"\nmatekiller "<<mlist.opt->matekiller;
    logger.file<<"\nevalpawns "<<scorer.opt->pawns;
    logger.file<<"\nevaldevelopment "<<scorer.opt->development;
    logger.file<<"\nevalpsqt "<<scorer.opt->psqt;
    logger.file<<"\nevalblocked "<<scorer.opt->blocked;
    logger.file<<"\nevalknights "<<scorer.opt->knights;
    logger.file<<"\nevalbishops "<<scorer.opt->bishops;
    logger.file<<"\nevalrooks "<<scorer.opt->rooks;
    logger.file<<"\nevalqueens "<<scorer.opt->queens;
    logger.file<<"\nsearchusehash "<<opt->usehash;
    logger.file<<"\nsearchpvs "<<opt->pvs;
    logger.file<<"\nsearchdonull "<<opt->donull;
    logger.file<<"\nsearchnullredfact "<<opt->nullredfact;
    logger.file<<"\nsearchaspwindow "<<opt->aspwindow;
    logger.file<<"\nsearchaspiration "<<opt->aspiration;
    logger.file<<endl;
    logger.file.flush();
    }
}

